/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.base;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWAutoStartupShutdownProperties;
import filenet.vw.base.VWString;
import filenet.vw.base.logging.Logger;
import filenet.vw.integrator.IVWComponentManager;
import filenet.vw.integrator.base.VWCMConvertTwo;
import filenet.vw.integrator.base.VWComponentManager;
import filenet.vw.server.Configuration;
import filenet.vw.server.VWBootstrapURL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.rmi.Naming;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VWComponentManagerServlet
extends GenericServlet {
    private VWComponentManager cmgr = null;
    private VWTaskXMLHandler m_xmlHandler = null;
    private static final int KEY_MASK = 0;
    private static String CMRegistryName = "FileNet.VW.VWComponentManager";
    private String adoptorName = null;
    private String routerURL = null;
    private String userName = "-1";
    private String password = null;
    private int cmPort = 32771;
    private int eventPort = 0;
    private boolean isCustomService = true;
    private String taskManagerXMLPath = null;
    private Properties properties = null;
    private String jndiInitCtx = null;
    private String reqlibs = null;
    private String m_jreParameters = null;
    private static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator");
    private static String m_className = "VWComponentManagerServlet";
    private String m_securityManager = null;
    private Boolean m_StopRequested = Boolean.FALSE;
    protected static boolean QUEUEMODE_ENABLED = true;
    protected static final String UNDEFINED = "UNDEFINED";
    private String m_queues = "*";
    private String m_aeinstallhomepath = null;
    private String m_codebaseURLForm = null;
    private MainThread m_mainThread = null;
    private String m_CeURI = null;
    private String m_CpURI = null;
    private String m_bootstrapURI = null;
    private static String P8BPMWSBROKER_PROPERTIES_FILENAME = null;
    private Vector m_componentManagers = new Vector(1);
    private static boolean bWindowsOS = System.getProperty("os.name").toUpperCase().startsWith("WINDOWS");

    private String[] parseStringList(String source) {
        if (source == null) {
            return null;
        }
        String m_method = "parseStringList:" + source;
        logger.entering(m_className, m_method);
        StringTokenizer st = new StringTokenizer(source, ", ");
        int nTokens = st.countTokens();
        String[] res = new String[nTokens];
        int i = 0;
        while (st.hasMoreTokens()) {
            res[i++] = st.nextToken();
        }
        return res;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        String m_method = "service";
    }

    private void getCEURI(ServletContext context) {
        String m_method = "getCEURI";
        try {
            InputStream configStream = context.getResourceAsStream("/WEB-INF/WcmApiConfig.properties");
            this.m_CeURI = Configuration.GetCEURI(configStream, null);
            if (logger.isFinest()) {
                logger.finest(m_className, "getCEURI", "CMServlet=" + this.m_CeURI);
            }
        }
        catch (Exception e) {
            logger.throwing(m_className, "getCEURI", e);
        }
    }

    public void init() {
        String m_method = "init";
        try {
            ServletConfig config = this.getServletConfig();
            ServletContext context = config.getServletContext();
            File f = new File(context.getRealPath("/WEB-INF"), "P8BPMWSBroker.properties");
            P8BPMWSBROKER_PROPERTIES_FILENAME = f.getCanonicalPath();
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "CMServlet=" + P8BPMWSBROKER_PROPERTIES_FILENAME);
            }
            this.getCEURI(context);
            this.m_mainThread = new MainThread(this);
            this.m_mainThread.start();
        }
        catch (Exception e) {
            logger.throwing(m_className, m_method, e);
        }
    }

    private String getProtectionDomain() {
        String m_method = "getProtectionDomain";
        try {
            Class<?> cls = ((Object)((Object)this)).getClass();
            logger.info(m_className, m_method, "getProtectionDomain" + cls.getProtectionDomain());
            logger.info(m_className, m_method, "getCodeSource=" + cls.getProtectionDomain().getCodeSource());
            logger.info(m_className, m_method, "getPermissions=" + cls.getProtectionDomain().getPermissions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private String getVersion(String className) {
        if (className != null) {
            try {
                int nFields;
                Class<?> cls = Class.forName(className);
                Object obj = cls.newInstance();
                Field[] fields = cls.getFields();
                StringBuffer buf = new StringBuffer(512);
                buf.append(className).append("<br>");
                int n = nFields = fields == null ? 0 : fields.length;
                while (--nFields > 0) {
                    buf.append(fields[nFields].getName()).append("=").append(fields[nFields].get(obj)).append("<br>");
                }
                return buf.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private String getObjectInfo(Object o) {
        StringBuffer buf = new StringBuffer();
        buf.append(o.getClass().getName()).append(", classLoader=").append(o.getClass().getClassLoader()).append(", toString=").append(o);
        return buf.toString();
    }

    public static String _get_FILE_DATE() {
        return "$Date:   02 Nov 2006 17:42:26  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   hakpata  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.29  $";
    }

    public String getRouterURL() {
        String m_method = "getRouterURL";
        logger.info(m_className, m_method, "VWComponentManagerServlet.getRouterURL()");
        return this.routerURL;
    }

    public void setRouterURL(String routerURL) {
        String m_method = "setRouterURL";
        logger.info(m_className, m_method, "VWComponentManagerServlet.setRouterURL(" + routerURL + ")");
        this.routerURL = routerURL;
    }

    public int getCMPort() {
        String m_method = "getCMPort";
        logger.info(m_className, m_method, "VWComponentManagerServlet.getCMPort()");
        return this.cmPort;
    }

    public void setCMPort(int cmPort) {
        String m_method = "setCMPort";
        logger.info(m_className, m_method, "VWComponentManagerServlet.setCMPort(" + cmPort + ")");
        this.cmPort = cmPort;
    }

    public int getEventPort() {
        String m_method = "getEventPort";
        logger.info(m_className, m_method, "VWComponentManagerServlet.getEventPort()");
        return this.eventPort;
    }

    public void setEventPort(int PPMPort) {
        String m_method = "setEventPort";
        logger.info(m_className, m_method, "VWComponentManagerServlet.setEventPort(" + PPMPort + ")");
        this.eventPort = PPMPort;
    }

    public String getRequiredLibraries() {
        return this.reqlibs;
    }

    public void setRequiredLibraries(String reqlibraries) {
        this.reqlibs = reqlibraries;
    }

    public String getJNDIContext() {
        return this.jndiInitCtx;
    }

    public void setJNDIContext(String context) {
        this.jndiInitCtx = context == null ? null : (context.trim().equals("") ? null : context);
    }

    protected String getQueues() {
        return this.m_queues;
    }

    protected void setQueues(String q) {
        this.m_queues = q;
    }

    private String getNameFromQueueMode() {
        if (!QUEUEMODE_ENABLED) {
            return this.getRouterURL();
        }
        if (this.m_queues.equals("*")) {
            return this.getRouterURL() + ".ALL";
        }
        return this.getRouterURL() + "." + this.m_queues.replace(',', '.');
    }

    public void stopCM() throws Exception {
        String m_method = "stopCM";
        this.m_StopRequested = Boolean.TRUE;
        logger.info(m_className, m_method, "VWComponentManagerServlet.stopCM()");
        boolean errorOccured = false;
        Node cmNode = null;
        VWComponentManager vwCM = null;
        Enumeration e = this.m_componentManagers.elements();
        while (e.hasMoreElements()) {
            try {
                cmNode = (Node)e.nextElement();
                this.cmFromXML(cmNode);
                logger.info(m_className, m_method, "Stopping component manager...");
                vwCM = (VWComponentManager)this.lookupCM(this.cmPort);
                if (this.isStarted()) {
                    vwCM.stop(true);
                }
                logger.info(m_className, m_method, "Component manager stopped successfully");
            }
            catch (Exception ex) {
                errorOccured = true;
                logger.info(m_className, m_method, new VWString("filenet.vw.integrator.base.VWComponentManagerServlet.UnableToStopCM", "Unable to stop Component Manager {0}: {1}").toString(this.getNameFromQueueMode(), ex.getLocalizedMessage()));
                logger.warning(m_className, m_method, ex.getLocalizedMessage());
            }
        }
        if (errorOccured) {
            throw new VWException("filenet.vw.integrator.base.VWComponentManagerServlet.AtLeastOneCMFailedToStop", "At least one Component Manager failed to stop");
        }
        this.cmgr = null;
    }

    private void startCM() throws Exception {
        String m_method = "startCM";
        logger.info(m_className, m_method, "VWComponentManagerServlet.startCM");
        if (!this.isStarted()) {
            try {
                block10: {
                    try {
                        IVWComponentManager smi = this.lookupCM(this.cmPort);
                        if (smi != null) {
                            String[] adaptorNames = smi.getAdaptorNames();
                            logger.info(m_className, m_method, "Component Manager is already running.");
                            throw new VWException("vw.integrator.base.VWCMAlreadyRunning", "The component manager is already running on this server.");
                        }
                    }
                    catch (Exception e) {
                        if (!(e instanceof VWException)) break block10;
                        throw e;
                    }
                }
                if (this.userName.equals("-1")) {
                    VWCMConvertTwo converter = new VWCMConvertTwo(0);
                    VWAuthItem item = converter.getDString(this.password);
                    if (item != null) {
                        this.userName = item.getName();
                        this.password = item.getPassword();
                        if (this.password != null && this.password.compareTo("\"\"") == 0) {
                            this.password = "";
                        }
                    } else {
                        logger.info(m_className, m_method, "Invalid name or password.");
                        throw new VWException("vw.integrator.base.VWCMInvalidUserNamePassword", "User name or password is invalid.");
                    }
                }
                String name = CMRegistryName + "." + this.getNameFromQueueMode();
                String queues = QUEUEMODE_ENABLED ? this.m_queues : "";
                logger.info(m_className, m_method, "Name=" + name + " queues=" + queues);
                this.m_CpURI = this.getRouterURL();
                logger.info(m_className, m_method, "Classpath URL" + this.m_CpURI);
                this.m_bootstrapURI = VWBootstrapURL.GetBootstrapURI(this.m_CeURI, this.m_CpURI);
                logger.info(m_className, m_method, "Class path bootstrap" + this.m_bootstrapURI);
                this.cmgr = new VWComponentManager(name, this.userName, this.password, this.m_bootstrapURI, this.cmPort, this.eventPort, this.isCustomService, queues);
                logger.info(m_className, m_method, "ComponentManager bound in registry.");
            }
            catch (Exception ex) {
                this.cmgr = null;
                throw ex;
            }
        }
    }

    private boolean isStarted() {
        return this.cmgr != null;
    }

    protected IVWComponentManager lookupCM(int rmiPort) throws Exception {
        String url = "rmi://localhost:" + rmiPort + "/" + CMRegistryName + "." + this.getRouterURL();
        return (IVWComponentManager)Naming.lookup(url);
    }

    private void addComponentManagerNode(Node n) {
        this.m_componentManagers.add(n);
    }

    private void initCMCollectionFromXML() throws Exception {
        String m_method = "initCMCollectionFromXML";
        StringBuffer aeinstallhome = VWAutoStartupShutdownProperties.GetAEInstallHome(P8BPMWSBROKER_PROPERTIES_FILENAME);
        if (null == aeinstallhome || aeinstallhome.length() == 0) {
            logger.info(m_className, m_method, "AE install home is undefined.");
            throw new VWException("vw.integrator.base.VWCMCSMBAEInstallHomeNotDefined", "AE Install home is undefined.");
        }
        this.m_aeinstallhomepath = new String(aeinstallhome);
        StringBuffer buff = VWAutoStartupShutdownProperties.GetTaskmanXMLPath(this.m_aeinstallhomepath);
        if (buff.length() == 0) {
            logger.info(m_className, m_method, "Unable to locate XML config file to get the Component Manager properties.");
            throw new VWException("vw.integrator.base.VWCMCSMBCannotFindXMLConfig", "Unable to locate XML config file to get the Component Manager properties.");
        }
        this.taskManagerXMLPath = new String(buff);
        this.m_xmlHandler = new VWTaskXMLHandler(this.taskManagerXMLPath);
        logger.info(m_className, m_method, "Task manager XML Path=" + this.taskManagerXMLPath);
        if (this.m_xmlHandler == null) {
            logger.info(m_className, m_method, "xmlHandler is null!");
            return;
        }
        Node cmcNode = VWTaskXMLHandler.getNodeNamed(this.m_xmlHandler.getRootNode(), "ComponentManagers");
        if (cmcNode == null || cmcNode.getNodeType() != 1) {
            logger.info(m_className, m_method, "Unable to find ComponentManagers node.");
            return;
        }
        Node[] definitionNodes = VWTaskXMLHandler.getNodesNamed(cmcNode, "ComponentManager");
        int nDefs = definitionNodes == null ? 0 : definitionNodes.length;
        for (int i = 0; i < nDefs; ++i) {
            try {
                this.addComponentManagerNode(definitionNodes[i]);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private void cmFromXML(Node node) {
        String m_method = "cmFromXML";
        if (node == null || node.getNodeType() != 1) {
            logger.info(m_className, m_method, "Unable to find this Component Manager node.");
            return;
        }
        Element ele = (Element)node;
        this.routerURL = ele.getAttribute("RouterURL");
        try {
            if (ele.getAttributeNode("Queues") != null) {
                this.setQueues(ele.getAttribute("Queues"));
            }
            this.cmPort = Integer.parseInt(ele.getAttribute("Port"));
            this.password = ele.getAttribute("Options");
            logger.info(m_className, m_method, "Options=" + this.password);
            logger.info(m_className, m_method, "Options string from taskman.xml=" + this.password);
            if (ele.getAttributeNode("JNDIInitialContextFactory") != null) {
                this.setJNDIContext(ele.getAttribute("JNDIInitialContextFactory"));
            }
            this.reqlibs = ele.getAttribute("RequiredLibraries");
            this.eventPort = Integer.parseInt(ele.getAttribute("EventPort"));
            if (ele.getAttributeNode("JREParameters") != null) {
                this.m_jreParameters = ele.getAttribute("JREParameters");
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    private String getNamingProviderURL() {
        String m_method = "getNamingProviderURL";
        String JREParameters = this.m_jreParameters;
        String s = null;
        boolean done = false;
        String[] sa = null;
        String providerURL = null;
        if (JREParameters != null && JREParameters.length() > 0) {
            String DELIM = " -";
            int i = -1;
            int j = 0;
            do {
                if ((i = JREParameters.indexOf(" -", j)) == -1) {
                    s = JREParameters.substring(j);
                } else {
                    s = VWComponentManagerServlet.ridOfQuotes(JREParameters.substring(j, i).trim());
                    j = i + 1;
                }
                if (!s.startsWith("-Djava.naming.provider.url")) continue;
                done = true;
                sa = new String[2];
                sa = s.split("=", 2);
                providerURL = sa[1];
            } while (!done && i != -1);
        }
        if (logger.isFinest()) {
            logger.finest(m_className, m_method, "jre parameters - provider URL =" + providerURL);
        }
        if (!s.startsWith("-Djava.naming.provider.url")) {
            providerURL = null;
        }
        return providerURL;
    }

    private static String ridOfQuotes(String s) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') continue;
            buf.append(c);
        }
        return buf.toString();
    }

    private String getAEInstallHomeURLForm() throws Exception {
        String m_method = "getAEInstallHomeURLForm";
        StringBuffer buffer = new StringBuffer().append(this.m_aeinstallhomepath);
        logger.info(m_className, m_method, "aeinstallhomepath=" + this.m_aeinstallhomepath);
        if (bWindowsOS) {
            int progPos;
            int sepPos = buffer.indexOf("\\");
            if (sepPos != -1) {
                buffer.replace(sepPos, sepPos + 1, "/");
            }
            if ((progPos = buffer.toString().toUpperCase(Locale.ENGLISH).indexOf("PROGRAM FILES")) != -1) {
                this.m_codebaseURLForm = buffer.replace(progPos, progPos + 13, "progra~1").toString();
                logger.info(m_className, m_method, "code base URL Form=" + this.m_codebaseURLForm);
            }
        }
        String aeInstallHomeURLForm = buffer.toString();
        logger.info(m_className, m_method, "aeInstallHome URL Form=" + aeInstallHomeURLForm);
        return aeInstallHomeURLForm;
    }

    private void setRMIServerCodeBaseProperty(Properties rmiSvrProps, String installHome) {
        System.setProperty("java.rmi.server.codebase", "file:/" + installHome + "\\Workplace\\WEB-INF\\" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\pe.jar" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\peResources.jar" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\Jace.jar" + " file:/" + installHome + "\\Workplace\\WEB-INF\\lib\\Sandesha.jar");
    }

    private String getRMIServerCodeBaseProperty() {
        return System.getProperty("java.rmi.server.codebase");
    }

    private void initCMProperties(Node node) throws Exception {
        String m_method = "initCMProperties";
        this.cmFromXML(node);
        System.setProperty("filenet.rmi.registry.inprocess", "true");
        String AEInstallHome = this.getAEInstallHomeURLForm();
        System.setProperty("filenet.ws.listener.properties.location", AEInstallHome + "/Workplace/WEB-INF");
        VWAutoStartupShutdownProperties autoStStProps = VWAutoStartupShutdownProperties.getAutoStartupShutdownProperties();
        Properties tmProps = autoStStProps.readTaskmanPropertiesFile(this.m_aeinstallhomepath);
        System.setProperty("filenet.wcmapiconfig", AEInstallHome + "/Workplace/WEB-INF/WcmApiConfig.properties");
        final String namingProviderURL = this.getNamingProviderURL();
        if (namingProviderURL != null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("filenet.naming.provider.url", namingProviderURL);
                    return null;
                }
            });
        }
        this.setRMIServerCodeBaseProperty(tmProps, AEInstallHome);
        logger.info(m_className, m_method, "java.rmi.server.codebase=" + this.getRMIServerCodeBaseProperty());
    }

    class MainThread
    extends Thread {
        private Throwable lastException = null;
        private VWComponentManagerServlet thisCM = null;

        public Throwable getLastException() {
            return this.lastException;
        }

        public MainThread(VWComponentManagerServlet aCMSvlt) {
            this.thisCM = aCMSvlt;
            this.setName("CMSvlt-Thread:" + m_className);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String m_method = "MainThread.run";
            try {
                Thread.sleep(60000L);
                boolean done = false;
                while (!done && !VWComponentManagerServlet.this.m_StopRequested.booleanValue()) {
                    done = true;
                    VWComponentManagerServlet.this.initCMCollectionFromXML();
                    Node cmNode = null;
                    Enumeration e = VWComponentManagerServlet.this.m_componentManagers.elements();
                    while (e.hasMoreElements()) {
                        cmNode = (Node)e.nextElement();
                        VWComponentManagerServlet.this.initCMProperties(cmNode);
                        logger.info(m_className, m_method, "Starting component manager...");
                        VWComponentManagerServlet.this.startCM();
                        logger.info(m_className, m_method, "Component manager started successfully");
                    }
                }
            }
            catch (Exception e) {
                if (e != null) {
                    System.err.println(e.getMessage());
                }
                logger.throwing(m_className, m_method, e);
            }
            finally {
                logger.exiting(m_className, m_method);
            }
        }
    }
}

